/*
 * Decompiled with CFR 0.152.
 */
package amp_libs.org.bouncycastle.jcajce.provider.asymmetric.edec;

import amp_libs.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import amp_libs.org.bouncycastle.crypto.util.PrivateKeyFactory;
import amp_libs.org.bouncycastle.crypto.util.PublicKeyFactory;
import amp_libs.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import amp_libs.org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import amp_libs.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import amp_libs.org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

class EdECUtil {
    EdECUtil() {
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof BCXDHPublicKey) {
            return ((BCXDHPublicKey)publicKey).engineGetKeyParameters();
        }
        if (publicKey instanceof BCEdDSAPublicKey) {
            return ((BCEdDSAPublicKey)publicKey).engineGetKeyParameters();
        }
        try {
            byte[] byArray = publicKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("no encoding for EdEC/XDH public key");
            }
            return PublicKeyFactory.createKey(byArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("cannot identify EdEC/XDH public key: " + exception.getMessage());
        }
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCXDHPrivateKey) {
            return ((BCXDHPrivateKey)privateKey).engineGetKeyParameters();
        }
        if (privateKey instanceof BCEdDSAPrivateKey) {
            return ((BCEdDSAPrivateKey)privateKey).engineGetKeyParameters();
        }
        try {
            byte[] byArray = privateKey.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("no encoding for EdEC/XDH private key");
            }
            return PrivateKeyFactory.createKey(byArray);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("cannot identify EdEC/XDH private key: " + exception.getMessage());
        }
    }
}

